/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed; // The elapsed time in seconds
uniform vec2 u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given by
// the number of pixels in each direction, typically 512 or 64. We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define here to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////
// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

vec3 doit( in vec2 pix )
{
vec2 p = -1.0 + 2.0*pix;
p.x *= iResolution.x/iResolution.y;

vec3 ro = vec3( 0.0, 0.0, 2.5 );
vec3 rd = normalize( vec3( p, -2.0 ) );

vec3 col = vec3(0.1);

// intersect sphere
float b = dot(ro,rd);
float c = dot(ro,ro) - 1.0;
float h = b*b - c;
if( h>0.0 )
{
float t = -b - sqrt(h);
vec3 pos = ro + t*rd;
vec3 nor = pos;

// texture mapping
vec2 uv;
uv.x = atan(nor.x,nor.z)/6.2831 - 0.03*iGlobalTime - iMouse.x/iResolution.x;
uv.y = acos(nor.y)/3.1416;
uv.y *= 0.5;
col = texture2D( iChannel0, uv ).xyz;

float o = smoothstep( 0.3,0.4,col.x);
col = mix( vec3(0.2,0.3,0.4), col, o );

// lighting
//col *= 0.1 + 0.9*max(nor.x*2.0+nor.z,0.0); //removed transparent shadow ~ET
col *= 0.2 + 0.8*max(nor.x*1.5+nor.z,0.3);
}
else
{
c = dot(ro,ro) - 10.0;
h = b*b - c;
float t = -b - sqrt(h);
vec3 pos = ro + t*rd;
vec3 nor = pos;

vec2 uv;
uv.x = 16.0*atan(nor.x,nor.z)/6.2831 - 0.05*iGlobalTime - iMouse.x/iResolution.x;
uv.y = 2.0*acos(nor.y)/3.1416;
col = texture2D( iChannel0, uv, 1.0 ).xyz;
col = col*col; col = col*col; col = col*col;
col *= 0.7;
vec3 sta = texture2D( iChannel0, 0.5*uv, 5.0 ).xyz;
sta = sta*sta;
col += sta*0.1;

}

col = 0.5*(col+sqrt(col));
return col;
}

void main(void)
{
// render this with four sampels per pixel
vec3 col0 = doit( (gl_FragCoord.xy+vec2(0.0,0.0) )/iResolution.xy );
vec3 col1 = doit( (gl_FragCoord.xy+vec2(0.5,0.0) )/iResolution.xy );
vec3 col2 = doit( (gl_FragCoord.xy+vec2(0.0,0.5) )/iResolution.xy );
vec3 col3 = doit( (gl_FragCoord.xy+vec2(0.5,0.5) )/iResolution.xy );
vec3 col = 0.25*(col0 + col1 + col2 + col3);

gl_FragColor = vec4(col,1.0);
}